//=============================================================================
// Job Button.
//=============================================================================
class JobButton extends DeusExDecoration;

var() float buttonLitTime;
var() sound buttonSound1;
var() sound buttonSound2;
var() bool bLit;
var() bool bWaitForEvent;
var bool isPressed;

var Vector	lastLoc, rpcLocation;
var bool		bIsMoving;

var() bool bModLooks;
var() texture JobClothes[8];
var() mesh JobMesh;
var() localized string JobMessage;
var() localized string JobName;
var Pawn ShopOwner;

replication 
{
	reliable if ( Role == ROLE_Authority )
		rpcLocation;
}

function Trigger(Actor Other, Pawn Instigator)
{
	if (bWaitForEvent)
		Timer();
}

function Timer()
{
	PlaySound(buttonSound2, SLOT_None);
	isPressed = False;
}

function Frob(Actor Frobber, Inventory frobWith)
{
local Actor A;
local Pawn P;

  P = Pawn(Frobber);

     Super.Frob(Frobber, frobwith);

     if (ShopOwner != None)
     ShopOwner.ClientMessage("|p2"$P.PlayerReplicationInfo.PlayerName$" has taken over the position of "$JobName$"!");
     BroadcastMessage("|p3"$P.PlayerReplicationInfo.PlayerName$"|p4 is now |p2"$JobName$"", true, 'CriticalEvent'); // Broadcast message to all players.
     P.ClientMessage(JobMessage);
     ShopOwner = P;
     if (bModLooks)
     {
     P.MultiSkins[0] = JobClothes[0];
     P.MultiSkins[1] = JobClothes[1];
     P.MultiSkins[2] = JobClothes[2];
     P.MultiSkins[3] = JobClothes[3];
     P.MultiSkins[4] = JobClothes[4];
     P.MultiSkins[5] = JobClothes[5];
     P.MultiSkins[6] = JobClothes[6];
     P.MultiSkins[7] = JobClothes[7];
     P.Mesh = JobMesh;
     }
}

singular function SupportActor(Actor standingActor)
{
	// do nothing
}

function Bump(actor Other)
{
	// do nothing
}

simulated function Tick( float deltaTime )
{						  	
	if ( Level.NetMode != NM_Standalone )
	{
		if ( Role == ROLE_Authority )
		{
			// Was moving, now at rest
			if ( bIsMoving && ( Location == lastLoc ))
				rpcLocation = Location;

			bIsMoving = ( Location != lastLoc );
			lastLoc = Location;
		}
		else
		{
			// Our replicated location changed which means the button has come to rest
			if ( lastLoc != rpcLocation )
			{
				SetLocation( rpcLocation );
				lastLoc = rpcLocation;
			}
		}
	}
	Super.Tick( deltaTime );
}

defaultproperties
{
     buttonLitTime=0.500000
     buttonSound1=Sound'DeusExSounds.Generic.Beep1'
     bInvincible=True
     ItemName="Job Button"
     bPushable=False
     Physics=PHYS_None
     RemoteRole=ROLE_SimulatedProxy
     Mesh=LodMesh'DeusExDeco.Button1'
     CollisionRadius=2.000000
     CollisionHeight=2.000000
     bCollideWorld=False
     bBlockActors=False
     Mass=5.000000
     Buoyancy=2.000000
}
